;**************************************
; Test LCD character
; Hardware  : CP-PIC V3.0/V4.0
; OSC 	    : 10 MHz [HS mode]
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 28/7/2002
;**************************************

     list p=18f442                 ; list directive to define processor
     #include <p18f442.inc>        ; processor specific variable definitions

#define   RS        PORTC,0        ; RS LCD
#define   E         PORTA,4        ; Enable LCD

com       EQU       0x20           ; 
dat       EQU       0x21           ; buffer for data
count1    EQU       0x22
count2    EQU       0x23
count3    EQU       0x24
count16   EQU	    0x25

          ORG       0x0000

;************ initial *******************

          
          clrf	    TRISA
	  clrf	    TRISC
	  clrf      TRISD          ; All port A,C,D is output
	  bsf	    E
	  call	    delay2
          movlw     B'00110011'    
          call      WR_INS
          movlw     B'00110010'
          call      WR_INS
          movlw     B'00101000'    ; 4 bits, 2 lines,5X7 dot 
          call      WR_INS
          movlw     B'00001100'    ; display on/off
          call      WR_INS
          movlw     B'00000110'    ; Entry mode
          call      WR_INS
          movlw     B'00000001'    ; Clear ram
          call      WR_INS
	  movlw     B'10010000'    ; point to address 10H in LCD
          call      WR_INS

          movlw     "P"
          call      WR_DATA
          movlw     "I"
          call      WR_DATA
          movlw     "C"
          call      WR_DATA
          movlw     "-"
          call      WR_DATA
          movlw     "1"
          call      WR_DATA
          movlw     "8"
          call      WR_DATA
          movlw     "F"
          call      WR_DATA
          movlw     "4"
          call      WR_DATA
          movlw     "4"
          call      WR_DATA
	  movlw	    "2"
	  call	    WR_DATA
	  
	 
          movlw	    .16		   ; counter = 16
	  movwf	    count16
shift	  movlw	    0x18           ; shift left 
	  call	    WR_INS
	  call	    delay2
	  decfsz    count16,f
	  goto	    shift
	  goto	    $      

;****************************************
; Write command to LCD
; Input  : W
; output : -
;****************************************
WR_INS    bcf       RS        ; clear RS
 	  bsf	    E
          movwf     com       ; W --> com
          andlw     0xF0      ; mask 4 bits MSB  W = X0        
          movwf     PORTD     ; Send 4 bits MSB
          bcf       E         ; 
          call      delay     ; __    __      
          bsf       E         ;   |__|
          swapf     com,w
          andlw     0xF0      ; 1111 0010
          movwf     PORTD     ; send 4 bits LSB
          bcf       E         ;
          call      delay     ; __    __      
          bsf       E         ;   |__|
          call      delay
          return

;***************************************
; Write data to LCD
; Input  : W
; Output : -
;***************************************
WR_DATA   bsf       RS
	  bsf	    E
          movwf     dat
          andlw     0xF0         
          movwf     PORTD
          bcf       E         
          call      delay     ; __    __
          bsf       E         ;   |__|
          swapf     dat,w
          andlw     0xF0
          movwf     PORTD
          bcf       E         ; 
          call      delay     ; __    __
          bsf       E         ;   |__|
	  call	    delay
          return

;***************************************
; Delay 
;***************************************
delay     movlw     .50
          movwf     count1
del1      clrf      count2
del2      decfsz    count2
          goto      del2
          decfsz    count1
          goto      del1
          return

delay2    movlw     .5
          movwf     count1
dely	  clrf	    count2
dely1     clrf      count3
dely2     decfsz    count3
          goto      dely2
          decfsz    count2
          goto      dely1
	  decfsz    count1
	  goto	    dely
          return

          END

